import { IActionParam } from "@core";
import { IParam } from "@core/interface";
import { MainView } from "../main-view";
import { PickupViewProps } from "./pickup-view-prop";
import { PickupViewState } from "./pickup-view-state";

/**
 * @description 选择视图
 * @export
 * @class PickupView
 * @extends {MainView}
 */
export class PickupView extends MainView {

  /**
   * @description 视图状态
   * @type {PickupViewState}
   * @memberof PickupView
   */
  public declare state: PickupViewState;

  /**
   * @description 选择视图输入参数
   * @type {PickupViewProps}
   * @memberof PickupView
   */
  public declare props: PickupViewProps;

  /**
   * 选择视图面板引用
   *
   * @type {IParam}
   * @memberof PickupView
   */
  public declare pickupViewPanel: IParam;

  /**
   * 使用视图初始化模块
   *
   * @memberof PickupView
   */
  public useViewInit() {
    super.useViewInit();
    this.pickupViewPanel = ref(null);
    this.initSelectedData();
    onMounted(() => {
      this.xDataControl = unref(this.pickupViewPanel);
    });
  }

  /**
   * 初始化选中数据
   *
   * @protected
   * @memberof PickupView
   */
  protected initSelectedData() {
    const { viewParams } = this.state;
    this.state.selectedData = viewParams?.selectedData ? ref(viewParams.selectedData) : ref([]);
  }

  /**
   * @description 取消
   * @memberof PickupView
   */
  public onCancel() {
    this.emit('viewEvent', { tag: this.state.viewName, action: 'viewClose', data: null });
  }

  /**
   * @description 确认
   * @memberof PickupView
   */
  public onConfirm() {
    this.emit('viewEvent', { tag: this.state.viewName, action: 'viewDataChange', data: this.state.selectedData });
    this.emit('viewEvent', { tag: this.state.viewName, action: 'viewClose', data: null });
  }

  /**
   * 处理部件事件
   *
   * @param {IActionParam} actionParam
   * @memberof PickupView
   */
  public onCtrlEvent(actionParam: IActionParam) {
    const { tag, action, data } = actionParam;
    if (action === 'selectionChange') {
      const { selectedData } = toRefs(this.state);
      if (data && data.length > 0) {
        selectedData.value = [...data];
      }
    }
    super.onCtrlEvent(actionParam);
  }

  /**
   * @description 安装视图所有功能模块的方法
   * @return {*} 
   * @memberof PickupView
   */
  public moduleInstall() {
    const superParams = super.moduleInstall();
    return {
      ...superParams,
      pickupViewPanel: this.pickupViewPanel,
      onCancel: this.onCancel.bind(this),
      onConfirm: this.onConfirm.bind(this)
    };
  }
}